/**
 * わんコメYouTubeアンケート専用テンプレート
 * 
 * ベースのデータ構造
 * {
    "id": "...",
    "title": "Hello world",
    "thumbnail": "...",
    "meta": "@YOUR_HANDLE • たった今 • 0 票",
    "choices": [
        {
            "label": "選択肢 A",
            "percentage": "50%",
            "ratio": 0.5
        },
        {
            "label": "選択肢 B",
            "percentage": "0%",
            "ratio": 0
        },
        {
            "label": "選択肢 C",
            "percentage": "0%",
            "ratio": 0
        },
        {
            "label": "選択肢 D",
            "percentage": "50%",
            "ratio": 0.5
        }
    ]
}
 */
const app = Vue.createApp({
  setup() {
    document.body.removeAttribute('hidden')
  },
  data () {
    return {
      loaded: false,
      title: '',
      voted: 0,
      choices: [],
      finished: false,
    }
  },
  methods: {},
  mounted () {
    OneSDK.setup({
      // YouTubeのアンケート取得
      permissions: OneSDK.usePermission([OneSDK.PERM.YT_SURVEY]),
    })
    OneSDK.subscribe({
      action: 'connected',
      callback: (data) => {
        // v9.0以降
        if (data.ytSurveys) {
          const latest = data.ytSurveys[0]
          if (latest) {
            const data = parseSurveyData(latest.data.meta.raw)
            this.title = data.title
            this.choices = data.choices
            this.voted = data.voted
            this.loaded = true
            this.finished = false
          }
        }
      }
    })
    // アンケート開始
    OneSDK.subscribe({
      action: 'yt.survey.start',
      callback: (poll) => {
        const data = parseSurveyData(poll)
        this.title = data.title
        this.choices = data.choices
        this.voted = data.voted
        this.loaded = true
        this.finished = false
      }
    })
    // アンケート更新
    OneSDK.subscribe({
      action: 'yt.survey.update',
      callback: (poll) => {
        const data = parseSurveyData(poll)
        this.title = data.title
        this.choices = data.choices
        this.voted = data.voted
        this.loaded = true
      }
    })
    // アンケート終了
    OneSDK.subscribe({
      action: 'yt.survey.finish',
      callback: (poll) => {
        const data = parseSurveyData(poll)
        this.title = data.title
        this.choices = data.choices
        this.voted = data.voted
        this.loaded = true
        this.finished = true
      }
    })
    OneSDK.connect()
  },
})

function parseSurveyData(data) {
  const [handle, time, votedStr] = data.meta.split(' • ')
  const voted = parseInt(votedStr, 10)
  const choices = data.choices.map(choice => {
    return {
      ...choice,
      voted: choice.ratio * voted
    }
  })
  return {
    title: data.title,
    handle: handle.trim(),
    time: time.trim(),
    voted,
    votedStr,
    choices
  }
}

OneSDK.ready().then(() => {
  app.mount("#container");
})
